#include <bits/stdc++.h>
#include <ext/pb_ds/tree_policy.hpp>
#include <ext/pb_ds/assoc_container.hpp>

using namespace std;
using namespace __gnu_pbds;

#define int long long
#define ll long long
#define double long double

const int inf = 1000000000000000000;
const int mod = 1000000007;

typedef tree <
        pair <int, int>,
        null_type,
        less < pair <int, int> >,
        rb_tree_tag,
        tree_order_statistics_node_update
> ordered_set;

ll binpow(int n, int k){
    if(k == 0){
        return 1ll;
    }

    int x = binpow(n, k / 2);
    if(k % 2 == 0){
        return (x * x) % mod;
    }else{
        return (((x * x) % mod) * n) % mod;
    }
}

struct seg_tree{
    vector <int> t;
    vector <int> p;

    void push(int v){
        if(p[v] != 0){
            t[v * 2] += p[v];
            t[v * 2 + 1] += p[v];
            p[v * 2] += p[v];
            p[v * 2 + 1] += p[v];
            p[v] = 0;
        }
    }

    void build(int v, int tl, int tr, vector <int> & h){
        if(tl + 1 == tr){
            t[v] = h[tl];
            return;
        }

        int tm = (tl + tr) / 2;
        build(v * 2, tl, tm, h);
        build(v * 2 + 1, tm, tr, h);
        t[v] = max(t[v * 2], t[v * 2 + 1]);
    }

    void update(int v, int l, int r, int tl, int tr, int val){
        if(tl >= r || tr <= l){
            return;
        }
        if(tl >= l && tr <= r){
            t[v] += val;
            p[v] += val;
            return;
        }

        push(v);
        int tm = (tl + tr) / 2;
        update(v * 2, l, r, tl, tm, val);
        update(v * 2 + 1, l, r, tm, tr, val);
        t[v] = max(t[v * 2], t[v * 2 + 1]);
    }

    int quer(int v, int l, int r, int tl, int tr){
        if(tl >= r || tr <= l){
            return -inf;
        }
        if(tl >= l && tr <= r){
            return t[v];
        }

        push(v);
        int tm = (tl + tr) / 2;
        return max(quer(v * 2, l, r, tl, tm), quer(v * 2 + 1, l, r, tm, tr));
    }
};

/*vector <int> f, fr;

int C(int n, int k){
    return (((f[n] * fr[k]) % mod) * fr[n - k]) % mod;
}*/

vector <int> dp;

void solve(){
    int n;
    cin >> n;
    cout << dp[n] << '\n';
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    /*int mm = 1e5 + 20;
    f.resize(mm);
    fr.resize(mm);
    f[0] = 1;
    fr[0] = 1;
    for(int i = 1; i < mm; ++i){
        f[i] = (f[i - 1] * i) % mod;
        fr[i] = binpow(f[i], mod - 2);
    }*/

    int m = 1000;
    dp.resize(m, inf);
    vector <int> ok(m);
    for(int i = 0; i < m; ++i){
        string s = to_string(i);

        bool okk = 1;
        int k = s.length();
        for(int j = 0; j < k; ++j){
            if(s[j] != s[k - 1 - j]){
                okk = 0;
            }
        }

        ok[i] = okk;
    }

    for(int i = 0; i < m; ++i){
        if(ok[i]){
            dp[i] = 1;
            continue;
        }
        for(int j = 0; j < i; ++j){
            if(ok[j]) {
                dp[i] = min(dp[i], dp[i - j] + 1);
            }
        }
    }

    int tests;
    cin >> tests;
    while(tests--){
        solve();
    }
}
